### Scelta moduli da lanciare ###
# con questa funzione si dà l'opportunità all'utente di scegliere quale modulo del 
# programma lanciare in modo tale da non dover lanciare ogni volta tutto il programma
#
def scelte():
    #
    def chiedi_conferma_1(messaggio):
        # Funzione per gestire gli input all/steps
        while True:
            risposta = input(messaggio + " (all/steps): ").strip().lower()
            if risposta in ["all", "steps"]:
                return risposta 
            print("Input non valido. Per favore, inserire 'all' o 'steps'.")  
    #
    def chiedi_conferma_2(messaggio):
        # Funzione per gestire gli input sì/no
        while True:
            risposta = input(messaggio + " (yes/no): ").strip().lower()
            if risposta in ["yes", "no"]:
                if risposta == "yes":
                    risposta=True
                    return risposta
                elif risposta == "no":
                    risposta=False
                    return risposta
                # 
            print("Input non valido. Per favore, inserire 'yes' o 'no'.")
    # domanda se si vuole lanciare l'intero programma o meno
    start=chiedi_conferma_1(
        "Salve, inserire 'all' se si vuole lanciare il programma per intero \n"
        "'steps' se si vuole lanciare solo parti di programma")
    #
    if start == "all":
        do_preprocessing = True
        do_divisione = True
        do_feature_selection = True
        do_training_validation_test = True
        do_PCA = True
    # domande per lanciare i singoli step
    elif start == "steps":
        do_preprocessing = chiedi_conferma_2("Lanciare la parte di preprocessing del dataset?")
        do_divisione = chiedi_conferma_2("Lanciare la parte di divisione del dataset?")
        do_feature_selection = chiedi_conferma_2("Lanciare la parte di feature selection?")
        do_training_validation_test = chiedi_conferma_2("Lanciare la parte di training-validation e test dei classificatori?")
        do_PCA = chiedi_conferma_2("Lanciare metodo PCA e classificazione con class.ori lineari?")
    #
    return do_preprocessing, do_divisione, do_feature_selection, do_training_validation_test, do_PCA
    
        